<?php

class PrintOrderAction extends CAction
{
	public function run($studentId = null, $companyId = null,
	                    array $orders = null,
	                    $start = null, $stop = null)
	{
		$c = new CDbCriteria();
		$c->join = '
			LEFT JOIN "Firma" "f" ON "f"."id" = "t"."idFirmy"
			LEFT JOIN "AdminKlasy" "ak" ON "ak"."idKlasy" = "f"."idKlasy"
		';
		$c->compare('"ak"."idAdmina"', Yii::app()->user->id);
		$c->compare('"t"."idUcznia"', $studentId);
		$c->compare('"t"."idFirmy"', $companyId);
		if (is_array($orders))
			$c->addInCondition('"t"."id"', $orders);
		if (!empty($start))
		{
			$c->addCondition(new CDbExpression('"t"."czasZakonczenia" >= TO_DATE(:startDate)'));
			$c->params[':startDate'] = date('d-m-Y H:i:s', strtotime($start . ' 00:00:00'));
		}
		if (!empty($stop))
		{
			$c->addCondition(new CDbExpression('"t"."czasZakonczenia" < TO_DATE(:stopDate)'));
			$c->params[':stopDate'] = date('d-m-Y H:i:s', strtotime($stop . ' 23:59:59')+1);
		}
		$c->with = array('idFirmy0', 'idZlecenia0.dziedzina', 'idZlecenia0.odpowiedziZlecenia', 'uczen.klasa');

		$zlecenia = ZlecenieFirmy::model()->findAll($c);

		if (count($zlecenia) == 0)
			throw new CHttpException(404, 'Brak rezultatów');

		require_once('PrintOrderPdf.php');

		$pdf = new PrintOrderPdf();

		$title = 'Raport wykonanych zleceń';
		if (!empty($companyId)) {
			if (count($zlecenia) == 1)
				$title = 'Zlecenie #' . $zlecenia[0]->id . ' (' . $zlecenia[0]->idFirmy0->nazwa . ' - ' . $zlecenia[0]->uczen->klasa->nazwa . ')';
			else
				$title = 'Zlecenia ' . $zlecenia[0]->idFirmy0->nazwa . ' (' . $zlecenia[0]->uczen->klasa->nazwa . ')';
		}
		else if (!empty($studentId)) {
			if (count($zlecenia) == 1)
				$title = 'Zlecenie #' . $zlecenia[0]->id . ' (' . $zlecenia[0]->uczen->imieNazwisko . ' - ' . $zlecenia[0]->uczen->klasa->nazwa . ')';
			else
				$title = 'Zlecenia ' . $zlecenia[0]->uczen->imieNazwisko . ' (' . $zlecenia[0]->uczen->klasa->nazwa . ')';
		}
		$pdf->SetTitle($title);
		$subject = '';
		if (!empty($studentId))
			$subject .= 'Uczeń: ' . $zlecenia[0]->uczen->imieNazwisko . ' (' . $zlecenia[0]->uczen->klasa->nazwa . ")\n";
		if (!empty($companyId))
			$subject .= 'Firma: ' . $zlecenia[0]->idFirmy0->nazwa . "\n";
		if (!empty($start))
			$subject .= 'Od: ' . $start . "\n";
		if (!empty($stop))
			$subject .= 'Do: ' . $stop . "\n";
		$pdf->SetSubject($subject);
		$pdf->SetKeywords('zlecenia');

		foreach ($zlecenia as $zlecenie)
		{
			$pdf->AddPage();
			$pdf->SetFont('dejavusans', '', 11);
			$pdf->Bookmark('Zlecenie #' . $zlecenie->id . ' - ' . $zlecenie->idZlecenia0->dziedzina->nazwa .
				' - ' . $zlecenie->idZlecenia0->kategoria . ' - ' . strtolower($zlecenie->idZlecenia0->poziomStr),
				0, 0, '', 'B', array(0,64,128));
			$pdf->writeHTML($this->getController()->renderPartial(
				'application.modules.teacher.controllers.main.views.orders_page', array('zlecenie' => $zlecenie), true),
				true, false, true, false, '');
		}

		if (count($zlecenia) > 1)
		{
			$pdf->addTOCPage();

			$pdf->SetFont('dejavusans', 'B', 16);
			$pdf->MultiCell(0, 15, 'Spis treści', 0, 'C', 0, 1, '', '', true, 0);
			$pdf->SetFont('dejavusans', '', 10);
			$bookmark_templates = array(
				$this->getController()->renderPartial('application.modules.teacher.controllers.main.views.orders_content', array(), true)
			);
			$pdf->addHTMLTOC(1, 'INDEX', $bookmark_templates, true, 'B', array(128,0,0));
			$pdf->endTOCPage();
		}

		$pdf->Output($title.'-'.date('Y-m-d H:i').'.pdf', 'I');
	}
}
